<?php
    $upcomingCourses = $upcomingCourses ?? [];
    $totalCourses = count($upcomingCourses);

    $courseRoute = '';
    $courseBtnText = '';

    if ($totalCourses > 0) {
        $courseRoute = route('course.list', ['upcoming' => true]);
        $courseBtnText = 'View Upcoming Course';
    }

    if (isAdmin() && $totalCourses < 1) {
        $courseRoute = route('course.create');
        $courseBtnText = 'Add Course';
    }
?>

<div class="bg-primary-50 py-16 sm:py-24 lg:py-[120px]">
    <div class="container">
        <!-- HEADER -->
        <div class="grid grid-cols-12 gap-4 items-center">
            <div class="col-span-full text-center max-w-[594px] mx-auto">
                <div class="area-subtitle">
                    <?php echo e(translate('Upcoming Courses')); ?>

                </div>
                <h2 class="area-title mt-2">
                    <?php echo e(translate('Our Upcoming')); ?>

                    <span class="title-highlight-one">
                        <?php echo e(translate('Courses')); ?>

                    </span>
                </h2>
            </div>
        </div>
        <!-- BODY -->
        <div class="swiper up-coming-courses-slider mt-10 lg:mt-[60px]">
            <div class="swiper-wrapper">
                <?php if (isset($component)) { $__componentOriginal855739d0c9ab52e9c2ed515a491ac1a1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal855739d0c9ab52e9c2ed515a491ac1a1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::cards.course-card-one','data' => ['isComing' => 'true','courses' => $upcomingCourses]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::cards.course-card-one'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['isComing' => 'true','courses' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($upcomingCourses)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal855739d0c9ab52e9c2ed515a491ac1a1)): ?>
<?php $attributes = $__attributesOriginal855739d0c9ab52e9c2ed515a491ac1a1; ?>
<?php unset($__attributesOriginal855739d0c9ab52e9c2ed515a491ac1a1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal855739d0c9ab52e9c2ed515a491ac1a1)): ?>
<?php $component = $__componentOriginal855739d0c9ab52e9c2ed515a491ac1a1; ?>
<?php unset($__componentOriginal855739d0c9ab52e9c2ed515a491ac1a1); ?>
<?php endif; ?>
            </div>
        </div>

        <?php if($courseRoute && $courseBtnText): ?>
            <div class="flex-center mt-10 lg:mt-[60px]">
                <a href="<?php echo e($courseRoute); ?>" title="<?php echo e($courseBtnText); ?>"
                    class="btn b-outline btn-primary-outline btn-xl !rounded-full font-medium text-[16px] md:text-[18px]"
                    aria-label="<?php echo e($courseBtnText); ?>">
                    <?php echo e(translate($courseBtnText)); ?>

                    <span class="hidden md:block">
                        <i class="ri-arrow-right-up-line text-[20px] rtl:before:content-['\ea66']"></i>
                    </span>
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\course\upcoming-course.blade.php ENDPATH**/ ?>