<form action="<?php echo e($action ?? '#'); ?>" method="post" class="form">
    <?php echo csrf_field(); ?>
    <?php if(isset($notice)): ?>
        <input type="hidden" value="<?php echo e($notice->id); ?>" name="id">
    <?php endif; ?>
    <input type="hidden" value="<?php echo e(authCheck()->id); ?>" name="user_id">
    <div class="card grid grid-cols-2 gap-x-4 gap-y-6">
        <div class="col-span-full xl:col-auto leading-none">
            <label for="noticeTitle" class="form-label"> <?php echo e(translate('Notice title')); ?> <span
                    class="text-danger">*</span></label>
            <input type="text" id="noticeTitle" placeholder="<?php echo e(translate('Notice Title')); ?>" name="title"
                class="form-input" autocomplete="off" value="<?php echo e(isset($notice) ? $notice->title : ''); ?>">
            <span class="text-danger error-text title_err"></span>
        </div>
        <input type="hidden" name="type" value="course">
        <div class="col-span-full xl:col-auto leading-none">
            <label for="noticeType" class="form-label"> <?php echo e(translate('Course Name')); ?> <span
                    class="text-danger">*</span></label>
            <select class="singleSelect" name="course_id" data-minimum-results-for-search="Infinity" required>
                <option selected disabled><?php echo e(translate('Select Course Type')); ?></option>
                <?php if(isset($courses)): ?>
                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $noticeCourse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $courseTranslations = parse_translation($noticeCourse?->course);
                        ?>
                        <option value="<?php echo e($noticeCourse->course_id); ?>"
                            <?php echo e(isset($notice) && $notice->course_id == $noticeCourse->course_id ? 'selected' : ''); ?>>
                            <?php echo e($courseTranslations['title'] ?? $noticeCourse?->course?->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

            </select>
            <span class="text-danger error-text course_id_err"></span>
        </div>
        <div class="col-span-full">
            <label for="courseType" class="form-label"> <?php echo e(translate('Message')); ?> </label>
            <textarea class="summernote" name="message"><?php echo clean($notice->description ?? ''); ?></textarea>
            <span class="text-danger error-text message_err"></span>
        </div>
    </div>
    <div class="card flex justify-end">
        <button type="submit" class="btn b-solid btn-primary-solid px-5 dk-theme-card-square">
            <?php echo e(isset($notice) ? translate('Update') : translate('Save')); ?>

        </button>
    </div>
</form>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\noticeboard\create-form.blade.php ENDPATH**/ ?>