<?php
    if (isOrganization()) {
        $prefix = 'organization';
    }

    if (isInstructor()) {
        $prefix = 'instructor';
    }

    $user = authCheck();
?>
<div class="fieldset">
    <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="company">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="id" value="<?php echo e($user?->userable?->id); ?>">
        <input type="hidden" name="user_id" value="<?php echo e($user?->id); ?>">

        <div class="card flex-center-between">
            <h6 class="text-xl font-semibold text-heading"> <?php echo e(translate('Previous Experience')); ?> </h6>
            <button type="button" class="btn b-solid btn-primary-solid add-experience">
                <i class="ri-add-circle-line text-inherit"></i>
                <span> <?php echo e(translate('Add')); ?> </span>
            </button>
        </div>

        <div class="experience-area" data-length="<?php echo e(isset($user->experiences) ? $user->experiences->count() : 0); ?>">
            <?php if(isset($user->experiences) & !empty($user->experiences)): ?>

                <?php $__currentLoopData = $user->experiences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $experience): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card experience-card relative">
                        <div class="grow grid grid-cols-2 gap-6 pt-10">
                            <div class="col-span-full lg:col-auto leading-none">
                                <label for="company-name" class="form-label"> <?php echo e(translate('Company Name')); ?> </label>
                                <input type="text" id="company-name" placeholder="<?php echo e(translate('Company name')); ?>"
                                    id="searchInput" class="form-input search-suggestion" data-search-type="company"
                                    autocomplete="off" name="experiences[<?php echo e($key); ?>][name]"
                                    value="<?php echo e($experience->name); ?>">
                                <div class="search-show"></div>
                            </div>
                            <div class="col-span-full lg:col-auto leading-none">
                                <label for="designation" class="form-label"> <?php echo e(translate('Designation')); ?> </label>
                                <input type="text" id="designation" placeholder="<?php echo e(translate('Designation')); ?>"
                                    class="form-input" autocomplete="off"
                                    name="experiences[<?php echo e($key); ?>][designation]"
                                    value="<?php echo e($experience?->pivot?->designation ?? ''); ?>">
                            </div>
                            <div class="col-span-full lg:col-auto leading-none">
                                <label for="start-date" class="form-label"> <?php echo e(translate('Start Date')); ?> </label>
                                <input type="date" id="start-date" placeholder="<?php echo e(translate('Start Date')); ?>"
                                    class="form-input" autocomplete="off"
                                    name="experiences[<?php echo e($key); ?>][start_date]"
                                    value="<?php echo e($experience?->pivot?->start_date ?? ''); ?>">
                            </div>
                            <div class="col-span-full lg:col-auto leading-none">
                                <div class="flex items-center gap-2">
                                    <div class="grow">
                                        <label for="end-date" class="form-label"> <?php echo e(translate('End Date')); ?> </label>
                                        <input type="date" id="end-date" placeholder="<?php echo e(translate('End Date')); ?>"
                                            class="form-input" autocomplete="off"
                                            name="experiences[<?php echo e($key); ?>][end_date]"
                                            value="<?php echo e($experience?->pivot?->end_date ?? ''); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-full lg:col-auto leading-none">
                                <div class="flex items-center gap-2">
                                    <input type="checkbox" name="experiences[<?php echo e($key); ?>][is_present]"
                                        id="current<?php echo e($key); ?>"
                                        class="check check-primary-solid continue-working"
                                        <?php echo e($experience?->pivot?->is_present == 1 ? 'checked' : ''); ?>>
                                    <label for="current<?php echo e($key); ?>" class="form-label m-0">
                                        <?php echo e(translate('To Present')); ?>

                                    </label>
                                </div>
                            </div>
                        </div>
                        <button type="button"
                            class="btn b-solid btn-danger-solid h-max shrink-0 dk-theme-card-square delete-btn absolute top-6 right-6"
                            data-action="<?php echo e(route($prefix . '.setting.info.delete', ['type' => 'experience', 'id' => $experience->pivot->id])); ?>">
                            <?php echo e(translate('Remove')); ?>

                        </button>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>

        <div class="card flex justify-end gap-4">
            <button type="button" class="prev-form-btn btn b-outline btn-primary-outline">
                <?php echo e(translate('Previous')); ?>

            </button>
            <button type="button" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                <?php echo e(translate('Save & Continue')); ?>

            </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\profile\experience-form.blade.php ENDPATH**/ ?>