<?php

declare(strict_types=1);

namespace Flasher\Prime\Http;

interface ResponseExtensionInterface
{
    /**
     * Renders the response by inserting the HTML response generated by the flasher library.
     *
     * @param RequestInterface  $request  the current request
     * @param ResponseInterface $response the current response
     *
     * @return ResponseInterface the modified response with the HTML response inserted
     */
    public function render(RequestInterface $request, ResponseInterface $response): ResponseInterface;
}
