<div class="bg-[#1B253A] py-3.5 hidden md:block">
    <div class="max-w-[1600px] mx-auto px-[12px]">
        <div class="flex-center-between">
            <div class="flex items-center justify-start space-x-5 divide-x divide-white/15 [&>:not(:first-child)]:pl-5 grow">
                <p class="area-description text-sm text-white/80">
                    <?php echo e(translate( 'New members: get your first 15 days of tutor Premium for free!' )); ?>

                    <a href="<?php echo e(route('course.list')); ?>" aria-label="Discount course link" class="text-secondary"><?php echo e(translate( 'Unlock discount now' )); ?>!</a>
                </p>
            </div>
            <div class="flex items-center justify-end space-x-5 divide-x divide-white/15 [&>:not(:first-child)]:pl-5 grow">
                <?php if(count(app('languages')) > 0): ?>
                    <div class="flex items-center">
                        <form method="get" action="<?php echo e(route('language.set')); ?>" id="language-form">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="admin_id"
                                value="<?php echo e(auth('admin')->check() ? auth('admin')->user()->id : null); ?>">
                            <input type="hidden" name="user_id"
                                value="<?php echo e(auth()->check() ? auth()->user()->id : null); ?>">
                            <select name="locale" aria-label="Choose Language"
                                onchange="event.preventDefault();
                                document.getElementById('language-form').submit();"
                                class="text-white *:text-heading dark:text-white font-semibold bg-transparent focus:outline-none cursor-pointer select-none text-sm bg-heading">
                                <?php $__currentLoopData = app('languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($language->code); ?>"
                                        <?php echo e(app()->getLocale() == $language->code ? 'selected' : ''); ?>>
                                        <?php echo e($language->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </form>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\themes\elearning-education\components\header\header-top-one.blade.php ENDPATH**/ ?>