<!DOCTYPE html>
<html>

<head>
    <title> <?php echo e(translate('Welcome to')); ?> <?php echo e(config('app.name')); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f7f7f7;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .header {
            background-color: #4CAF50;
            color: white;
            padding: 5px 0;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }

        .content {
            padding: 20px;
        }

        .button {
            display: inline-block;
            padding: 10px 20px;
            margin: 20px 0;
            background-color: #4CAF50;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            color: white !important
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <h1> <?php echo e(translate('Welcome to')); ?> <?php echo e(config('app.name')); ?></h1>
        </div>
        <div class="content">
            <p> <?php echo e(translate('Hello')); ?> <?php echo e($user['first_name']); ?>,</p>
            <?php if(!isset($user['type'])): ?>
                <p> <?php echo e(translate("Thank you for apply course. We're excited to have you on board!")); ?> </p>
            <?php endif; ?>

            <p>
                <?php echo e(translate('Please click the button below to verify your email address')); ?> :
            </p>
            <p>
                <a href="<?php echo e($url); ?>" class="button">
                    <?php echo e(translate('Verify Email')); ?>

                </a>
            </p>
            <p><?php echo e(translate('If you did not create an account, no further action is required')); ?>.</p>
            <p> <?php echo e(translate('Best Regards')); ?> ,<br><?php echo e(config('app.name')); ?> <?php echo e(translate('Team')); ?> </p>
        </div>
    </div>
</body>

</html>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\mail\register.blade.php ENDPATH**/ ?>