<?php
    $user = authCheck();
?>

<div class="fieldset">
    <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="extra-information">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="id" value="<?php echo e($user?->userable?->id); ?>">
        <input type="hidden" name="user_id" value="<?php echo e($user?->id); ?>">
        <div class="grid grid-cols-12 gap-6 card">
            <div class="col-span-full lg:col-span-6 leading-none">
                <label for="country" class="form-label"><?php echo e(translate('Country')); ?></label>
                <select class="singleSelect country-state" name="country_id">
                    <option selected disabled><?php echo e(translate('Select Country')); ?></option>
                    <?php $__currentLoopData = get_all_country(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($country->id); ?>"
                            <?php echo e($user?->userable?->country_id == $country->id ? 'selected' : ''); ?>>
                            <?php echo e($country->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-span-full lg:col-span-6 leading-none">
                <label for="state" class="form-label"> <?php echo e(translate('State')); ?> </label>
                <select class="singleSelect state-city" id="stateOption" name="state_id">
                    <option selected disabled> <?php echo e(translate('Select State')); ?> </option>
                </select>
            </div>
            <div class="col-span-full lg:col-span-6 leading-none">
                <label for="city" class="form-label"><?php echo e(translate('City')); ?></label>
                <select class="city-list" id="cityOption" name="city_id">
                    <option selected disabled> <?php echo e(translate('Select City')); ?> </option>
                </select>
            </div>
            <div class="col-span-full lg:col-span-6 leading-none">
                <label for="address" class="form-label"> <?php echo e(translate('Address')); ?> </label>
                <input type="text" id="address" placeholder="<?php echo e(translate('Address')); ?>" name="address"
                    class="form-input" autocomplete="off" value="<?php echo e($user?->userable?->address); ?>">
            </div>
            <?php if(!isOrganization()): ?>
                <div class="col-span-full lg:col-span-6 leading-none">
                    <label for="age" class="form-label"> <?php echo e(translate('Age')); ?> </label>
                    <input type="number" id="age" name="age" placeholder="<?php echo e(translate('Age')); ?>"
                        class="form-input" autocomplete="off" value="<?php echo e($user?->userable?->age); ?>">
                </div>
                <div class="col-span-full">
                    <h6 class="text-sm font-medium text-gray-500 dark:text-dark-text mb-1"> <?php echo e(translate('Gender')); ?>

                    </h6>
                    <div class="flex items-center gap-4">
                        <div class="flex items-center gap-2">
                            <input type="radio" name="gender" id="male"
                                <?php echo e($user?->userable?->gender == 'male' ? 'checked' : ''); ?> value="male"
                                class="radio radio-primary">
                            <label for="male" class="form-label mb-0 leading-none"> <?php echo e(translate('Male')); ?>

                            </label>
                        </div>
                        <div class="flex items-center gap-2">
                            <input type="radio" name="gender" id="female" value="female"
                                class="radio radio-primary"
                                <?php echo e($user?->userable?->gender == 'female' ? 'checked' : ''); ?>>
                            <label for="female" class="form-label mb-0 leading-none"> <?php echo e(translate('Female')); ?>

                            </label>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="card flex justify-end gap-4">
            <button type="button" class="prev-form-btn btn b-outline btn-primary-outline"> <?php echo e(translate('Previous')); ?>

            </button>
            <button type="button" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                <?php echo e(translate('Save & Continue')); ?> </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\profile\extra-information-form.blade.php ENDPATH**/ ?>