<?php if(!empty($blogs)): ?>
    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $translations = parse_translation($blog);
            $title = $translations['title'] ?? $blog->title ?? '';
            $thumbnail =
                $blog->thumbnail && fileExists('lms/blogs', $blog->thumbnail) == true
                    ? asset("storage/lms/blogs/{$blog->thumbnail}")
                    : asset('lms/frontend/assets/images/450x300.svg');
        ?>

        <div class="swiper-slide <?php echo e($class ?? null); ?>">
            <div class="bg-primary-50 rounded-2xl p-5 h-full group/blog">
                <!-- BLOG THUMBNAIL -->
                <div class="relative aspect-video rounded-2xl overflow-hidden">
                    <div class="blog-thumb">
                        <img data-src="<?php echo e($thumbnail); ?>" alt="Blog Thumbnail"
                            class="size-full object-cover group-hover/blog:scale-110 custom-transition">
                    </div>
                    <!-- badge -->
                    <?php if(isset($blog->blogCategories) && !empty($blog->blogCategories)): ?>
                        <?php $__currentLoopData = $blog->blogCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($loop->first): ?>
                                <?php $categoryTranslations = parse_translation($category);  ?>
                                <span
                                    class="badge b-solid badge-secondary-solid rounded-full !text-heading dark:text-white absolute top-4 right-4 z-10"><?php echo e($categoryTranslations['name'] ?? $category->name ?? ''); ?></span>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
                <!-- BLOG CONTENT -->
                <div class="mt-6">
                    <div class="flex-center-between pb-4 mb-6 border-b border-heading/10">
                        <div class="flex items-center gap-1 area-description text-sm !leading-none shrink-0">
                            <i class="ri-user-line"></i>
                            <?php
                                $admin = $blog->adminAuthor ?? null;
                                $author = $blog->author ?? null;
                            ?>
                            <?php if($admin): ?>
                                <span><?php echo e($admin->name); ?></span>
                            <?php else: ?>
                                <?php
                                    $user = $author->userable ?? null;
                                    $name = $user->first_name ?? ($user->name ?? null);
                                ?>
                                <span><?php echo e($name); ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="flex items-center gap-1 area-description text-sm !leading-none shrink-0">
                            <i class="ri-calendar-2-line"></i>
                            <span><?php echo e(customDateFormate($blog->created_at, format: 'd M Y')); ?></span>
                        </div>
                        <?php if($blog->comments->count() > 0): ?>
                            <div class="flex items-center gap-1 area-description text-sm !leading-none shrink-0">
                                <i class="ri-message-3-line"></i>
                                <span> <?php echo e($blog->comments->count()); ?> <?php echo e(translate('Comments')); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                    <h6 class="area-title font-bold !text-xl mt-3 group-hover/blog:text-primary custom-transition">
                        <!-- title -->
                        <a href="<?php echo e(route('blog.detail', $blog->slug)); ?>" class="line-clamp-2" aria-label="Blog title">
                            <?php echo e($title); ?>

                        </a>
                    </h6>
                    <a href="<?php echo e(route('blog.detail', $blog->slug)); ?>"
                        class="btn btn-sm text-heading dark:text-white group-hover/blog:text-primary font-medium custom-transition mt-6"
                        aria-label="View blog details">
                        <?php echo e(translate('View Detail')); ?>

                        <span class="hidden md:block">
                            <i class="ri-arrow-right-up-line text-[20px] rtl:before:content-['\ea66']"></i>
                        </span>
                    </a>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\cards\blog-card-one.blade.php ENDPATH**/ ?>