<?php
    $user = $instructor?->userable ?? null;
    $profile_img = $user?->profile_img ?? null;
    $thumbnail =
        $profile_img && fileExists('lms/instructors', $profile_img) == true
            ? asset('storage/lms/instructors/' . $profile_img)
            : asset('lms/frontend/assets/images/370x396.svg');

    $userTranslations = parse_translation($user);

    if ($user?->designation) {
        $designationTranslate = parse_translation($user?->designation);
    }
?>

<div class="col-span-full xl:col-span-6">
    <div
        class="flex flex-col sm:flex-row items-center gap-7 p-7 h-full border border-heading/15 rounded-lg hover:border-transparent hover:shadow-lg custom-transition">
        <div class="aspect-[1/1.17] max-w-60 rounded-xl overflow-hidden shrink-0">
            <a href="<?php echo e(route('users.detail', $instructor->id)); ?>" aria-label="Instructor profile image">
                <img data-src="<?php echo e($thumbnail); ?>" alt="Instructor profile image" class="size-full object-cover">
            </a>
        </div>
        <div class="grow">
            <div class="area-description line-clamp-4">
                <?php echo $userTranslations['about'] ?? ($instructor?->userable?->about ?? ''); ?>

            </div>
            <h6 class="text-primary text-xl font-bold mt-6">
                <a href="<?php echo e(route('users.detail', $instructor->id)); ?>" aria-label="Instructor full name">
                    <?php echo e($userTranslations['first_name'] ?? $instructor->userable?->first_name); ?>

                    <?php echo e($userTranslations['last_name'] ?? $instructor->userable?->last_name); ?>

                </a>
            </h6>
            <div class="text-heading/70">
                <?php echo e($designationTranslate['title'] ?? ($instructor?->userable?->designation?->title ?? '')); ?>

            </div>
            <?php if (isset($component)) { $__componentOriginal82de39c2f55cf270f1ec734732705f02 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal82de39c2f55cf270f1ec734732705f02 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::social.social-list-three','data' => ['socials' => $instructor->socials,'ulClass' => 'flex items-center gap-2.5 mt-5','itemClass' => '','listClass' => '']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::social.social-list-three'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['socials' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($instructor->socials),'ulClass' => 'flex items-center gap-2.5 mt-5','itemClass' => '','listClass' => '']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal82de39c2f55cf270f1ec734732705f02)): ?>
<?php $attributes = $__attributesOriginal82de39c2f55cf270f1ec734732705f02; ?>
<?php unset($__attributesOriginal82de39c2f55cf270f1ec734732705f02); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal82de39c2f55cf270f1ec734732705f02)): ?>
<?php $component = $__componentOriginal82de39c2f55cf270f1ec734732705f02; ?>
<?php unset($__componentOriginal82de39c2f55cf270f1ec734732705f02); ?>
<?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\cards\instructor\card-three.blade.php ENDPATH**/ ?>