<?php if(count($bundle->courses) > 0): ?>

    <?php
        $bundleTranslations = parse_translation($bundle);
    ?>
    <div class="col-span-full lg:col-span-6">
        <div class="p-6 border border-border h-full rounded-xl hover:bg-primary-50 overflow-x-auto custom-transition">
            <table class="w-full table-auto whitespace-nowrap">
                <caption class="area-title text-xl text-left rtl:text-right mb-7">
                    <?php echo e($bundleTranslations['title'] ?? $bundle->title); ?>

                </caption>
                <tbody class="divide-y divide-border">
                    <?php $__currentLoopData = $bundle->courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $reviews = review($course);
                            $translations = parse_translation($course);
                            $thumbnail =
                                $course->thumbnail && fileExists('lms/courses/thumbnails', $course->thumbnail) == true
                                    ? asset("storage/lms/courses/thumbnails/{$course->thumbnail}")
                                    : asset('lms/frontend/assets/images/420x252.svg');

                        ?>
                        <tr>
                            <td class="py-5 text-left rtl:text-right">
                                <a href="<?php echo e(route('course.detail', $course->slug)); ?>" aria-label="Course bundle link"
                                    class="flex items-center gap-2">
                                    <div class="size-20 rounded-50 overflow-hidden dk-theme-card-square">
                                        <img data-src="<?php echo e($thumbnail); ?>" alt="Course thumbnail"
                                            class="size-full object-cover">
                                    </div>
                                    <span>
                                        <span class="flex items-center gap-2">
                                            <span class="flex items-center gap-0.5 text-secondary">
                                                <?php echo show_rating($reviews['average_rating']); ?>

                                            </span>
                                            <p class="area-description text-sm !leading-none">
                                                (<?php echo e(dotZeroRemove($reviews['average_rating']) ?? 0); ?>

                                                <?php echo e(translate('Rating')); ?>)
                                            </p>

                                        </span>
                                        <span class="inline-block area-title text-lg !leading-none line-clamp-1 mt-4">
                                            <?php echo e(str_limit($translations['title'] ?? $course->title, 30, '..')); ?>

                                        </span>
                                    </span>
                                </a>
                            </td>
                            <td class="py-5 text-right rtl:text-left">
                                <div class="text-primary text-lg font-bold leading-none">
                                    <?php if($course?->courseSetting?->is_free): ?>
                                        <?php echo e(translate('Free')); ?>

                                    <?php else: ?>
                                        <?php if(isset($course?->coursePrice) &&
                                                $course?->coursePrice?->discount_flag == 1 &&
                                                $course?->coursePrice?->discount_period != '' &&
                                                dateCompare($course?->coursePrice?->discount_period) == true): ?>
                                            $<?php echo e(dotZeroRemove($course?->coursePrice?->discounted_price ?? 0)); ?>

                                            <del>$
                                                <?php echo e(dotZeroRemove($course?->coursePrice?->price ?? 0)); ?></del>

                                            <?php echo e(discountPercentage($course?->coursePrice?->price, $course?->coursePrice?->discounted_price)); ?>%
                                            <?php echo e(translate('OFF')); ?>

                                        <?php else: ?>
                                            $<?php echo e(dotZeroRemove($course?->coursePrice?->price ?? 0)); ?>

                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="flex-center gap-4 mt-5">
                <?php if(purchaseCheck($bundle->id, type: 'bundle') !== true): ?>
                    <?php if(is_free($bundle->id, type: 'bundle')): ?>
                        <form action="<?php echo e(route('course.enrolled')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" value="<?php echo e($bundle->id); ?>" name="id">
                            <input type="hidden" value="bundle" name="type">

                            <div class="flex gap-2">
                                <div
                                    class="btn b-outline border-border btn-xl h-12 bg-white hover:border-border hover:!text-heading dark:text-white !rounded-full font-medium">
                                    <b> <?php echo e(translate('Free')); ?> </b>
                                </div>
                                <?php if(auth()->guard()->check()): ?>
                                    <button type="submit"
                                        class="btn b-solid btn-primary-solid btn-xl h-12 !rounded-full font-medium"
                                        aria-label="Enroll The Bundle">
                                        <?php echo e(translate('Enroll The Bundle')); ?>

                                        <i class="ri-arrow-right-line text-inherit"></i>
                                    </button>
                                <?php endif; ?>
                                <?php if(auth()->guard()->guest()): ?>
                                    <button type="button"
                                        class="btn b-solid btn-primary-solid btn-xl h-12 !rounded-full font-medium auth-login"
                                        aria-label="Enroll The Bundle">
                                        <?php echo e(translate('Enroll The Bundle')); ?>

                                        <span class="hidden md:block">
                                            <i class="ri-arrow-right-up-line text-[20px] rtl:before:content-['\ea66']"></i>
                                        </span> </button>
                                <?php endif; ?>
                            </div>
                        </form>
                    <?php else: ?>
                        <div
                            class="btn b-outline border-border btn-xl h-12 bg-white hover:border-border hover:!text-heading dark:text-white !rounded-full font-medium">
                            <?php echo e(translate('Total')); ?>:
                            <b>$<?php echo e(dotZeroRemove($bundle?->price ?? 0)); ?></b>
                        </div>
                        <a class="btn b-solid btn-primary-solid btn-xl h-12 !rounded-full font-medium add-to-cart cursor-pointer"
                            data-course-id="<?php echo e($bundle->id); ?>" data-type="bundle" aria-label="Buy the Bundle">
                            <?php echo e(translate('Buy the Bundle')); ?> <span class="hidden md:block">
                                <i class="ri-arrow-right-up-line text-[20px] rtl:before:content-['\ea66']"></i>
                            </span> </a>
                    <?php endif; ?>
                <?php else: ?>
                    <a class="btn b-solid btn-primary-solid btn-xl h-12 !rounded-full font-medium" href="#"
                        aria-label="Click Bundle Course for learn">
                        <?php echo e(translate('Click Bundle Course for learn')); ?>

                        <span class="hidden md:block">
                            <i class="ri-arrow-right-up-line text-[20px] rtl:before:content-['\ea66']"></i>
                        </span>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\cards\bundle-card-one.blade.php ENDPATH**/ ?>