<?php
    if (isOrganization()) {
        $prefix = 'organization';
    }
    if (isInstructor()) {
        $prefix = 'instructor';
    }
    $user = authCheck();
?>

<div class="fieldset">
    <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="education" name="education-form">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="id" value="<?php echo e($user?->userable?->id); ?>">
        <input type="hidden" name="user_id" value="<?php echo e($user?->id); ?>">

        <div class="card flex-center-between">
            <h6 class="text-xl font-semibold text-heading"> <?php echo e(translate('Educational Qualification')); ?> </h6>
            <button type="button" class="btn b-solid btn-primary-solid add-education">
                <i class="ri-add-circle-line text-inherit"></i>
                <span> <?php echo e(translate('Add')); ?> </span>
            </button>
        </div>

        <div class="education-area" data-length="<?php echo e(isset($user->educations) ? $user->educations->count() : 0); ?>">
            <?php if(isset($user->educations) && !empty($user->educations)): ?>
                <?php $__currentLoopData = $user->educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $education): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card education-card relative">
                        <div class="grow grid grid-cols-2 gap-6 pt-10">
                            <div class="col-span-full md:col-auto relative">
                                <label class="form-label"> <?php echo e(translate('Institute Name')); ?> </label>
                                <input type="text" placeholder="<?php echo e(translate('Enter Institute Name')); ?>"
                                    name="educations[<?php echo e($key); ?>][name]" id="searchInput"
                                    class="form-input search-suggestion" data-search-type="university"
                                    value="<?php echo e($education->name); ?>">
                                <div class="search-show"></div>
                            </div>
                            <div class="col-span-full md:col-auto">
                                <label class="form-label mb-2 d-block">
                                    <?php echo e(translate('Department')); ?>

                                </label>
                                <input type="text" placeholder="<?php echo e(translate('Enter Department')); ?>"
                                    name="educations[<?php echo e($key); ?>][department]" class="form-input"
                                    value="<?php echo e($education?->pivot?->department ?? ''); ?>">
                            </div>
                            <div class="col-span-full md:col-auto">
                                <label class="form-label"> <?php echo e(translate('Degree')); ?> </label>
                                <input type="text"
                                    placeholder="<?php echo e(translate('Example')); ?> : <?php echo e(translate('BSC')); ?>"
                                    name="educations[<?php echo e($key); ?>][degree]" class="form-input"
                                    value="<?php echo e($education?->pivot?->degree ?? ''); ?>">
                            </div>
                            <div class="col-span-full md:col-auto">
                                <label class="form-label"><?php echo e(translate('CGPA')); ?></label>
                                <input type="text" placeholder="<?php echo e(translate('Enter CGPA')); ?>"
                                    name="educations[<?php echo e($key); ?>][cgpa]" class="form-input"
                                    value="<?php echo e($education?->pivot?->cgpa ?? ''); ?>">
                            </div>

                            <div class="col-span-full md:col-auto">
                                <label class="form-label"> <?php echo e(translate('Duration')); ?>(<?php echo e(translate('Years')); ?>)
                                </label>
                                <input type="text" placeholder="<?php echo e(translate('Enter Duration')); ?>"
                                    name="educations[<?php echo e($key); ?>][duration]" class="form-input"
                                    value="<?php echo e($education?->pivot?->duration ?? ''); ?>">
                            </div>
                            <div class="col-span-full md:col-auto">
                                <label class="form-label"> <?php echo e(translate('Passing Year')); ?> </label>
                                <select class="singleSelect" name="educations[<?php echo e($key); ?>][passing_year]" n>
                                    <option selected disabled><?php echo e(translate('Select Passing Year')); ?>

                                    </option>
                                    <?php $__currentLoopData = range(date('Y'), 2000); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($year); ?>"><?php echo e($year); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <button type="button"
                            class="btn b-solid btn-danger-solid h-max shrink-0 delete-btn dk-theme-card-square absolute top-6 right-6"
                            data-action="<?php echo e(route($prefix . '.setting.info.delete', ['type' => 'education', 'id' => $education->pivot->id])); ?>">
                            <?php echo e(translate('Remove')); ?>

                        </button>
                        <script>
                            document.forms['education-form'].elements['educations[<?php echo e($key); ?>][passing_year]'].value =
                                "<?php echo e($education?->pivot?->passing_year); ?>";
                        </script>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>

        <div class="card flex justify-end gap-4">
            <button type="button" class="prev-form-btn btn b-outline btn-primary-outline"> <?php echo e(translate('Previous')); ?>

            </button>
            <button type="button" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                <?php echo e(translate('Save & Continue')); ?>

            </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\profile\education-form.blade.php ENDPATH**/ ?>