<!-- Course Table -->
<div class="overflow-x-auto scrollbar-table max-h-[350px] smooth-scrollbar" data-scrollbar>

    <?php if($topCourses->count() > 0): ?>
        <table
            class="table-auto w-full whitespace-nowrap text-left text-xs text-gray-500 dark:text-dark-text font-semibold leading-none">
            <thead>
                <tr>
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                        <?php echo e(translate('Course')); ?>

                    </th>
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                        <?php echo e(translate('Publish on')); ?>

                    </th>
                    <?php if(isset($sales)): ?>
                        <th
                            class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                            <?php echo e(translate('Total Sale')); ?>

                        </th>
                    <?php else: ?>
                        <th
                            class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                            <?php echo e(translate('Enrolled')); ?>

                        </th>
                    <?php endif; ?>
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                        <?php echo e(translate('Price')); ?>

                    </th>
                </tr>
            </thead>
            <tbody class="divide-y divide-dashed divide-gray-900/60 dark:divide-dark-border-three">
                <?php $__currentLoopData = $topCourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $thumbnail =
                            $course->thumbnail && fileExists('lms/courses/thumbnails', $course->thumbnail) == true
                                ? asset("storage/lms/courses/thumbnails/{$course->thumbnail}")
                                : asset('lms/assets/images/placeholder/thumbnail612.jpg');

                        $translations = parse_translation($course);

                    ?>
                    <tr>
                        <td class="px-3.5 py-4">
                            <div class="flex items-center gap-2">
                                <a href="<?php echo e(route('course.detail', $course->slug)); ?>"
                                    class="size-10 rounded-50 overflow-hidden dk-theme-card-square">
                                    <img src="<?php echo e($thumbnail); ?>" alt="thumb" class="size-full object-cover">
                                </a>
                                <div>
                                    <h6 class="text-heading dark:text-white font-semibold mb-1.5 line-clamp-1">
                                        <a target="_blank"
                                            href="<?php echo e(route('course.detail', $course->slug)); ?>"><?php echo e(str_limit($translations['title'] ?? $course->title, 15)); ?></a>
                                    </h6>
                                    <p class="font-normal"><?php echo e(translate('Author')); ?> -
                                        <?php $__currentLoopData = $course->instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $userTranslations = parse_translation($instructor?->userable);
                                            ?>

                                            <?php echo e($userTranslations['first_name'] ?? $instructor?->userable?->first_name); ?>

                                            <?php echo e($userTranslations['last_name'] ?? $instructor?->userable?->last_name); ?>


                                            <?php echo e(!$loop->last ?? '|'); ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </p>
                                </div>
                            </div>
                        </td>
                        <td class="px-3.5 py-4"><?php echo e(customDateFormate($course->created_at, 'd M Y')); ?></td>

                        <?php if(isset($sales)): ?>
                            <td class="px-3.5 py-4"><?php echo e($course->sale_count_number ?? 0); ?></td>
                        <?php else: ?>
                            <td class="px-3.5 py-4"><?php echo e($course->enrollments_count); ?></td>
                        <?php endif; ?>
                        <td class="px-3.5 py-4">
                            <?php echo e($course?->courseSetting?->is_free ? translate('free') : $course?->coursePrice?->price); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php else: ?>
        <?php if (isset($component)) { $__componentOriginal5d13c2904e1f07d85da185576dbff28d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5d13c2904e1f07d85da185576dbff28d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.empty-card','data' => ['title' => 'No top Courses']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.empty-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'No top Courses']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5d13c2904e1f07d85da185576dbff28d)): ?>
<?php $attributes = $__attributesOriginal5d13c2904e1f07d85da185576dbff28d; ?>
<?php unset($__attributesOriginal5d13c2904e1f07d85da185576dbff28d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5d13c2904e1f07d85da185576dbff28d)): ?>
<?php $component = $__componentOriginal5d13c2904e1f07d85da185576dbff28d; ?>
<?php unset($__componentOriginal5d13c2904e1f07d85da185576dbff28d); ?>
<?php endif; ?>
    <?php endif; ?>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\admin\admin\top-course.blade.php ENDPATH**/ ?>