<?php
    $blogs = $blogs ?? [];
    $totalBlogs = count($blogs);

    $blogRoute = '';
    $blogBtnText = '';

    if ($totalBlogs > 0) {
        $blogRoute = route('blog.list');
        $blogBtnText = 'See All Blog';
    }

    if (isAdmin() && $totalBlogs < 1) {
        $blogRoute = route('blog.create');
        $blogBtnText = 'Add Blog';
    }
?>

<!-- START BLOG AREA -->
<div class="bg-white pt-16 sm:pt-24 lg:pt-[120px]">
    <div class="container">
        <!-- HEADER -->
        <div class="grid grid-cols-12 gap-4 items-center">
            <div class="col-span-full md:col-span-7 xl:col-span-6 md:pr-20">
                <div class="area-subtitle"> <?php echo e(translate('Frequent Updates')); ?> </div>
                <h2 class="area-title mt-2">
                    <?php echo e(translate('Updated News &')); ?>

                    <span class="title-highlight-one"><?php echo e(translate('Blogs')); ?></span>
                </h2>
            </div>

            <?php if($blogRoute && $blogBtnText): ?>
                <div class="col-span-full md:col-span-5 xl:col-span-6 md:justify-self-end">
                    <a href="<?php echo e($blogRoute); ?>" title="<?php echo e($blogBtnText); ?>"
                        class="btn b-solid btn-primary-solid btn-xl !rounded-full font-medium text-[16px] md:text-[18px]"
                        aria-label="<?php echo e($blogRoute); ?>">
                        <?php echo e(translate($blogBtnText)); ?>

                        <span class="hidden md:block">
                            <i class="ri-arrow-right-up-line text-[20px] rtl:before:content-['\ea66']"></i>
                        </span>
                    </a>
                </div>
            <?php endif; ?>
        </div>
        <!-- BODY -->
        <div class="swiper blog-slider mt-10 lg:mt-[60px]">
            <div class="swiper-wrapper">
                <?php if (isset($component)) { $__componentOriginaleaa929815116684c6513eebad3279f39 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleaa929815116684c6513eebad3279f39 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::cards.blog-card-one','data' => ['blogs' => $blogs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::cards.blog-card-one'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['blogs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($blogs)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleaa929815116684c6513eebad3279f39)): ?>
<?php $attributes = $__attributesOriginaleaa929815116684c6513eebad3279f39; ?>
<?php unset($__attributesOriginaleaa929815116684c6513eebad3279f39); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleaa929815116684c6513eebad3279f39)): ?>
<?php $component = $__componentOriginaleaa929815116684c6513eebad3279f39; ?>
<?php unset($__componentOriginaleaa929815116684c6513eebad3279f39); ?>
<?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\blog\latest-blog-one.blade.php ENDPATH**/ ?>