<?php if(!empty($course->instructors)): ?>
    <?php $__currentLoopData = $course->instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!-- profile -->
        <?php
            $user = $instructor->userable ?? null;
            $profile_img = $user?->profile_img ?? '';

            $imgSrc =
                $profile_img && fileExists('lms/instructors', $profile_img) == true
                    ? asset("storage/lms/instructors/{$profile_img}")
                    : asset('lms/frontend/assets/images/370x396.svg');

            $userTranslations = parse_translation($user);
            $designationTranslations = parse_translation($user?->designation);

        ?>

        <?php if($loop->first): ?>
            <article>
                <h2 class="area-title xl:text-3xl mb-5"><?php echo e(translate('Course Instructor')); ?></h2>
                <div class="flex flex-col md:flex-row gap-4 border border-border rounded-2xl p-7">
                    <div class="size-44 overflow-hidden rounded-xl lg:rounded-50 shrink-0">
                        <img data-src="<?php echo e($imgSrc); ?>" alt="Instructor profile image" class="size-full object-cover">
                    </div>
                    <div class="grow">
                        <h6 class="area-title text-xl !leading-none font-bold">
                            <?php echo e($userTranslations['first_name'] ?? $user?->first_name); ?>

                            <?php echo e($userTranslations['last_name'] ?? $user?->last_name); ?>

                        </h6>
                        <div class="text-heading/60 text-sm leading-none mt-1">
                            <?php echo e($designationTranslations['title'] ?? ($user?->designation?->title ?? '')); ?>

                        </div>
                        <a href="mailto:<?php echo e($instructor->email); ?>"
                            class="text-sm text-primary"><?php echo e($instructor->email); ?></a>
                        <?php if($user->about): ?>
                            <div class="text-heading/70 font-semibold leading-[1.55] mt-6">
                                <?php echo clean($userTranslations['about'] ?? ($user->about ?? '')); ?>

                            </div>
                        <?php endif; ?>

                        <?php if(isset($instructor['socials']) && $instructor['socials']->count() > 0): ?>
                            <!-- SOCIAL MEDIA -->
                            <div class="flex items-center gap-4 w-max mt-5">
                                <div class="text-heading dark:text-white font-bold leading-none">
                                    <?php echo e(translate('Follow')); ?> -
                                </div>
                                <?php if (isset($component)) { $__componentOriginal895c5f52f52ad266a2c4117783433c56 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal895c5f52f52ad266a2c4117783433c56 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::social.social-list-one','data' => ['socials' => $instructor['socials'],'ulClass' => 'flex items-center gap-2','itemClass' => 'size-10 rounded-50 bg-primary-50 text-heading/60 flex-center hover:bg-primary hover:text-white custom-transition']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::social.social-list-one'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['socials' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($instructor['socials']),'ulClass' => 'flex items-center gap-2','itemClass' => 'size-10 rounded-50 bg-primary-50 text-heading/60 flex-center hover:bg-primary hover:text-white custom-transition']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal895c5f52f52ad266a2c4117783433c56)): ?>
<?php $attributes = $__attributesOriginal895c5f52f52ad266a2c4117783433c56; ?>
<?php unset($__attributesOriginal895c5f52f52ad266a2c4117783433c56); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal895c5f52f52ad266a2c4117783433c56)): ?>
<?php $component = $__componentOriginal895c5f52f52ad266a2c4117783433c56; ?>
<?php unset($__componentOriginal895c5f52f52ad266a2c4117783433c56); ?>
<?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </article>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\course\details\course-instructor.blade.php ENDPATH**/ ?>