<?php
    $locale = request()->locale ?? app()->getLocale();
    $translations = [];
    $language = $language ?? null;
    if ($language && $locale) {
        $translations = parse_translation($language, $locale);
    }
?>


<?php if (isset($component)) { $__componentOriginald7f77a02f879fd4954ea3c39c4e952cb = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb = $attributes; } ?>
<?php $component = Modules\LMS\View\Components\Dashboard\Layout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Modules\LMS\View\Components\Dashboard\Layout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> <?php echo e(isset($language) ? translate('Edit') : translate('Create')); ?>

        <?php echo e(translate('Language')); ?> <?php $__env->endSlot(); ?>
    <!-- BREADCRUMB -->
    <?php if(is_active('language.translate') === 'active'): ?>
        <div class="flex items-center justify-end gap-4 mb-2">
            <h2 class="card-title"><?php echo e(translate('Translate Language')); ?></h2>
            <form method="GET" class="sm:block" id="change-translate-language">
                <select onchange="window.location.href=this.options[this.selectedIndex].value" name="id"
                    class="text-gray-500 dark:text-dark-text dark:bg-dark-card-shade font-semibold bg-white focus:outline-none cursor-pointer select-none text-sm border dk-border-one px-2 py-2 rounded-md dk-theme-card-square">
                    <?php $__currentLoopData = app('languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($lang->code); ?>"
                            <?php echo e(isset($locale) && $locale == $lang->code ? 'selected' : ''); ?>>
                            <?php echo e($lang->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </form>
        </div>
    <?php endif; ?>
    <form action="<?php echo e(isset($language) ? route('language.update', $language->id) : route('language.store')); ?>"
        method="post" class="form">
        <?php if(isset($language)): ?>
            <?php echo method_field('put'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>
        <input type="hidden" name="locale" class="form-input" value="<?php echo e($locale ?? ''); ?>">
        <div class="grid grid-cols-12 card mb-0">
            <div class="col-span-full md:col-span-6">
                <div class="leading-none">
                    <label for="courseTitle" class="form-label">
                        <?php echo e(translate('Name')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <input type="text" id="courseTitle" name="name"
                        value="<?php echo e($translations['name'] ?? ($language->name ?? '')); ?>" class="form-input">
                    <span class="text-danger error-text name_err"></span>
                </div>
                <?php if(is_active('language.translate') == 'active'): ?>
                    <input type="hidden" id="code" name="code" value="<?php echo e($language->code ?? ''); ?>"
                        class="form-input">
                    <span class="text-danger error-text code_err"></span>
                <?php endif; ?>
                <?php if(is_active('language.translate') !== 'active'): ?>
                    <div class="mt-6 leading-none">
                        <label for="code" class="form-label">
                            <?php echo e(translate('Short Code')); ?>

                            <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                        </label>
                        <input type="text" id="code" name="code" value="<?php echo e($language->code ?? ''); ?>"
                            class="form-input">
                        <span class="text-danger error-text code_err"></span>
                    </div>
                <?php endif; ?>

                <button type="submit" class="btn b-solid btn-primary-solid w-max mt-5">
                    <?php echo e(isset($language) ? translate('Update') : translate('Save')); ?>

                </button>
            </div>
        </div>
    </form>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb)): ?>
<?php $attributes = $__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb; ?>
<?php unset($__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald7f77a02f879fd4954ea3c39c4e952cb)): ?>
<?php $component = $__componentOriginald7f77a02f879fd4954ea3c39c4e952cb; ?>
<?php unset($__componentOriginald7f77a02f879fd4954ea3c39c4e952cb); ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\admin\language\form.blade.php ENDPATH**/ ?>