<?php
    if (!$course) {
        return;
    }
    $reviews = review($course);
    $imagePath = 'lms/courses/thumbnails';
    $thumbnail =
        !empty($course?->thumbnail) && fileExists($imagePath, $course->thumbnail)
            ? asset("storage/{$imagePath}/{$course->thumbnail}")
            : asset('lms/frontend/assets/images/420x252.svg');
    $translations = $translations ?? parse_translation($course);
    $categoryTranslations = parse_translation($course->category);
?>

<div class="col-span-full md:col-span-6 lg:col-span-4 h-full">
    <div
        class="flex flex-col h-full rounded-xl custom-transition overflow-hidden hover:shadow-md group/course <?php echo e($cardBg ?? 'bg-white'); ?>">
        <!-- COURSE THUMBNAIL -->
        <div class="relative aspect-[1.71] overflow-hidden shrink-0">
            <img data-src="<?php echo e($thumbnail); ?>" alt="Course thumbnail"
                class="size-full object-cover group-hover/course:scale-110 custom-transition">
            <!-- ADD TO WISHLIST -->
            <?php if(auth()->guard()->check()): ?>
                <?php
                    $class = user_wishlist_check($course->id) ? 'active' : '';
                ?>
                <label for="course_<?php echo e($course->id); ?>"
                    class="flex-center absolute top-3 right-4 rtl:right-auto rtl:left-4 size-11 rounded-50 bg-white cursor-pointer select-none z-[1] add-wishlist group/wishlist <?php echo e($class); ?>"
                    data-id="<?php echo e($course->id); ?>">
                    <input type="checkbox" id="course_<?php echo e($course->id); ?>"
                        class="appearance-none before:font-remix before:content-['\eae5'] before:text-heading before:text-xl group-[.active]/wishlist:before:content-['\eae4'] cursor-pointer">
                </label>
            <?php else: ?>
                <label for="course_<?php echo e($course->id); ?>"
                    class="flex-center absolute top-3 right-4 rtl:right-auto rtl:left-4 size-11 rounded-50 bg-white cursor-pointer select-none z-[1]"
                    data-id="<?php echo e($course->id); ?>">
                    <a href="<?php echo e(route('auth.login')); ?>" id="course_<?php echo e($course->id); ?>"
                        class="appearance-none before:font-remix before:content-['\eae5'] before:text-heading before:text-xl checked:before:content-['\eae4'] cursor-pointer">
                    </a>
                </label>
            <?php endif; ?>
        </div>
        <!-- COURSE CONTENT -->
        <div class="px-4 lg:px-5 py-6 rounded-b-xl grow">
            <div class="flex-center-between gap-2 flex-wrap">
                <div class="flex items-center gap-1.5 area-description !text-secondary text-sm !leading-none shrink-0">
                    <i class="ri-book-marked-fill"></i>
                    <span class="text-heading"><?php echo e(translate('Lesson')); ?> :
                        <?php echo e($course->chapters?->count() ?? 0); ?></span>
                </div>
                <div class="flex items-center gap-1.5 area-description !text-secondary text-sm !leading-none shrink-0">
                    <i class="ri-user-3-fill"></i>
                    <span class="text-heading"><?php echo e(translate('Student')); ?> :
                        <?php echo e($course->students?->count() ?? 0); ?></span>
                </div>
                <div class="flex items-center gap-1.5 area-description !text-secondary text-sm !leading-none shrink-0">
                    <i class="ri-graduation-cap-fill"></i>
                    <span
                        class="text-heading"><?php echo e($categoryTranslations['title'] ?? ($course->category->title ?? '')); ?></span>
                </div>
            </div>
            <h6 class="area-title font-bold !text-xl mt-5 group-hover/course:text-secondary custom-transition">
                <a href="<?php echo e(route('course.detail', $course->slug)); ?>" class="line-clamp-2"
                    aria-label="Course details link">
                    <?php echo e($translations['title'] ?? ($course->title ?? '')); ?>

                </a>
            </h6>
            <div class="flex-center-between gap-2 pt-4 mt-6 border-t border-heading/10">
                <div class="text-heading text-xl !leading-none font-bold flex items-center flex-wrap gap-1.5">
                    <?php if(isset($course?->coursePrice) &&
                            $course?->coursePrice?->discount_flag == 1 &&
                            $course?->coursePrice?->discount_period != '' &&
                            dateCompare($course?->coursePrice?->discount_period) == true): ?>
                        <span>$<?php echo e(dotZeroRemove($course?->coursePrice?->discounted_price ?? 0)); ?></span>
                        <del class="text-heading/50 text-[16px] font-semibold">
                            $<?php echo e(dotZeroRemove($course?->coursePrice?->price ?? 0)); ?>

                        </del>
                    <?php else: ?>
                        <span>
                            $<?php echo e(dotZeroRemove($course?->coursePrice?->price ?? 0)); ?>

                        </span>
                    <?php endif; ?>
                </div>
                <div
                    class="size-10 flex-center border-[2.5px] border-dashed border-heading/10 rounded-50 ms-4 me-auto relative shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1"
                        class="linear-circle size-[41px] circle-rating"
                        data-rating="<?php echo e(dotZeroRemove($reviews['average_rating']) ?? 0); ?>">
                        <circle cx="20.5" cy="20.5" r="46%"></circle>
                    </svg>
                    <span
                        class="text-heading text-sm !leading-none font-bold"><?php echo e(dotZeroRemove($reviews['average_rating']) ?? 0); ?></span>
                    <span class="text-warning absolute top-[47%] -translate-y-1/2 -right-2.5">
                        <i class="ri-star-s-fill"></i>
                    </span>
                </div>
                <div class="flex items-center gap-1 area-description text-sm !leading-none shrink-0">
                    <a href="<?php echo e(route('course.detail', $course->slug)); ?>"
                        class="btn b-solid btn-primary-solid !text-heading font-bold capitalize"
                        aria-label="Buy course">
                        <?php echo e(translate('Buy course')); ?>

                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\cards\course\card-four.blade.php ENDPATH**/ ?>