<?php
    $general = get_theme_option(key: 'general') ?? [];
?>

<!-- EMAIL -->
<div class="col-span-full sm:col-span-6 lg:col-span-3">
    <div class="bg-primary-50 rounded-xl flex-center flex-col text-center py-12 px-4 h-full">
        <div class="size-14 rounded-50 flex-center bg-primary text-white p-2">
            <i class="ri-mail-open-fill text-2xl"></i>
        </div>
        <div class="area-title text-2xl !leading-none mt-5">
            <?php echo e(translate('Email')); ?>

        </div>
        <p class="area-description text-sm mt-4"> <?php echo e($general['email'] ?? ''); ?></p>
        <?php if(isset($general['second_email'])): ?>
            <p class="area-description text-sm mt-1"> <?php echo e($general['second_email'] ?? ''); ?></p>
        <?php endif; ?>
    </div>
</div>
<!-- PHONE -->
<div class="col-span-full sm:col-span-6 lg:col-span-3">
    <div class="bg-primary-50 rounded-xl flex-center flex-col text-center py-12 px-4 h-full">
        <div class="size-14 rounded-50 flex-center bg-primary text-white p-2">
            <i class="ri-phone-fill text-2xl"></i>
        </div>
        <div class="area-title text-2xl !leading-none mt-5">
            <?php echo e(translate('Phone')); ?>

        </div>
        <p class="area-description text-sm mt-4"><?php echo e($general['phone'] ?? ''); ?></p>

        <?php if(isset($general['second_phone'])): ?>
            <p class="area-description text-sm mt-1"><?php echo e($general['second_phone'] ?? ''); ?></p>
        <?php endif; ?>
    </div>
</div>
<!-- OFFICE HOUR -->
<div class="col-span-full sm:col-span-6 lg:col-span-3">
    <div class="bg-primary-50 rounded-xl flex-center flex-col text-center py-12 px-4 h-full">
        <div class="size-14 rounded-50 flex-center bg-primary text-white p-2">
            <i class="ri-home-office-fill text-2xl"></i>
        </div>
        <div class="area-title text-2xl !leading-none mt-5">
            <?php echo e(translate('Office Hour')); ?>

        </div>
        <p class="area-description text-sm mt-4"> <?php echo e($general['office_hours'] ?? ''); ?> </p>
        <?php if(isset($general['support_hours'])): ?>
            <p class="area-description text-sm mt-1"> <?php echo e(translate('Online')); ?> <?php echo e($general['support_hours'] ?? ''); ?>

            </p>
        <?php endif; ?>
    </div>
</div>
<!-- LOCATION -->
<div class="col-span-full sm:col-span-6 lg:col-span-3">
    <div class="bg-primary-50 rounded-xl flex-center flex-col text-center py-12 px-4 h-full">
        <div class="size-14 rounded-50 flex-center bg-primary text-white p-2">
            <i class="ri-map-pin-fill text-2xl"></i>
        </div>
        <div class="area-title text-2xl !leading-none mt-5">
            <?php echo e(translate('Location')); ?>

        </div>
        <p class="area-description text-sm mt-4">
            <?php echo e($general['address'] ?? null); ?>

        </p>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\contact-form\contact-information.blade.php ENDPATH**/ ?>